/*
 * Decompiled with CFR 0.152.
 */
package com.cinterion.io;

import com.cinterion.internal.ATCommandHelper;
import com.cinterion.io.ATCommandFailedException;
import com.cinterion.io.ATCommandListener;
import com.cinterion.io.ATCommandResponseListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import me.regexp.RE;

public class ATCommand {
    private int m_iPort = -2;
    private String m_strResponse = null;
    private ATCommandResponseListener m_ResponseListener = null;
    private int m_State = 0;
    private int m_V24State = 0;
    private final ComEventThread m_EventThread = new ComEventThread();
    private final Listeners m_Listeners = new Listeners();
    private final Parser m_Parser = new Parser();
    private final OutputStreamDataConnection m_DataOut = new OutputStreamDataConnection();
    private final InputStreamDataConnection m_DataIn = new InputStreamDataConnection();
    private int m_iRegisteredListeners = 0;
    private int m_iExecutedListeners = 0;
    private final Object m_oSyncListeners = new Object();
    private static final int BUFFER_SIZE = 256;
    private static final int MAX_CMD_LEN = 1024;
    private static final int MAX_RSP_LEN = 1024;
    private static final byte[] ABORT_COMMAND = new byte[]{13, 13, 27};
    private static final String ENCODING = "US-ASCII";
    private Sync m_Sync = new Sync();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ATCommand(boolean bl) throws ATCommandFailedException, IllegalStateException {
        this.m_iPort = ATCommandHelper.nativeOpenATCommand((boolean)bl);
        if (this.m_iPort == -5) {
            throw new IllegalStateException("No free AT interpreter instance");
        }
        if (this.m_iPort < 0) {
            throw new ATCommandFailedException();
        }
        ComEventThread comEventThread = this.m_EventThread;
        synchronized (comEventThread) {
            this.m_EventThread.start();
            try {
                this.m_EventThread.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public ATCommand(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws ATCommandFailedException, IllegalStateException {
        this(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() throws IOException, IllegalStateException {
        Sync sync = this.m_Sync;
        synchronized (sync) {
            this.m_Listeners.clear();
            if (this.m_iPort >= 0) {
                try {
                    this.cancelCommand();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_State = 5;
                this.m_Sync.snotifyAll();
                ATCommandHelper.nativeNotifyCom((int)this.m_iPort);
                try {
                    this.m_Sync.swait();
                    this.m_EventThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ATCommandHelper.nativeCloseATCommand((int)this.m_iPort);
            }
            this.m_iPort = -2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String send(String string) throws ATCommandFailedException, IllegalStateException, IllegalArgumentException {
        Sync sync = this.m_Sync;
        synchronized (sync) {
            this.send(string, null);
            try {
                this.m_Sync.swait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.m_strResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void send(String string, ATCommandResponseListener aTCommandResponseListener) throws ATCommandFailedException, IllegalStateException, IllegalArgumentException {
        Sync sync = this.m_Sync;
        synchronized (sync) {
            byte[] byArray;
            if (string == null) {
                throw new IllegalArgumentException("Null object passed");
            }
            if (string.length() == 0) {
                throw new IllegalArgumentException("Empty command passed");
            }
            if (string.length() > 1024) {
                throw new IllegalArgumentException("AT command too long");
            }
            switch (this.m_State) {
                case 3: 
                case 4: {
                    throw new IllegalStateException("ATCommand instance is in transparent data mode");
                }
                case 5: {
                    throw new IllegalStateException("ATCommand instance has been released");
                }
                case 1: {
                    throw new IllegalStateException("There is already an AT command running");
                }
            }
            try {
                byArray = string.getBytes(ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = string.getBytes();
            }
            try {
                this.m_ResponseListener = aTCommandResponseListener;
                this.m_State = 1;
                ATCommandHelper.nativeSendBytes((int)this.m_iPort, (byte[])byArray, (int)0, (int)byArray.length);
            }
            catch (IOException iOException) {
                this.m_ResponseListener = null;
                this.m_State = 0;
                throw new ATCommandFailedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cancelCommand() throws ATCommandFailedException, IllegalStateException {
        Sync sync = this.m_Sync;
        synchronized (sync) {
            switch (this.m_State) {
                case 0: 
                case 2: {
                    throw new IllegalStateException("There is currently no AT command running");
                }
                case 3: 
                case 4: {
                    throw new IllegalStateException("ATCommand instance is in transparent data mode");
                }
                case 5: {
                    throw new IllegalStateException("ATCommand instance has been released");
                }
            }
            try {
                this.AbortCommand();
                this.m_Sync.swait();
            }
            catch (Exception exception) {
                this.m_State = 0;
                this.m_Sync.snotifyAll();
                throw new ATCommandFailedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setDTR(boolean bl) throws IOException {
        Sync sync = this.m_Sync;
        synchronized (sync) {
            ATCommandHelper.nativeSetDtrHW((int)this.m_iPort, (boolean)bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean getRING() {
        Sync sync = this.m_Sync;
        synchronized (sync) {
            return (this.m_V24State & 0x80) != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean getDCD() {
        Sync sync = this.m_Sync;
        synchronized (sync) {
            return (this.m_V24State & 0x40) != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean getDSR() {
        Sync sync = this.m_Sync;
        synchronized (sync) {
            return (this.m_V24State & 0x10) != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean getCONN() {
        Sync sync = this.m_Sync;
        synchronized (sync) {
            return (this.m_V24State & 0x4000) != 0;
        }
    }

    public boolean csdSupported() {
        try {
            return ATCommandHelper.nativeGetCSDSupport((int)this.m_iPort);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void addListener(ATCommandListener aTCommandListener) {
        this.m_Listeners.addListener(aTCommandListener);
    }

    public void removeListener(ATCommandListener aTCommandListener) {
        this.m_Listeners.removeListener(aTCommandListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String breakConnection() throws IOException {
        Sync sync = this.m_Sync;
        synchronized (sync) {
            if (this.m_State != 3) {
                throw new IOException("ATCommand instance is not in transparent data mode");
            }
            this.m_State = 4;
            this.m_Parser.Reset();
            this.m_Sync.snotifyAll();
            ATCommandHelper.nativeBreakData((int)this.m_iPort);
            try {
                this.m_Sync.swait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.m_strResponse;
        }
    }

    public OutputStream getDataOutputStream() {
        return this.m_DataOut;
    }

    public InputStream getDataInputStream() {
        return this.m_DataIn;
    }

    private ATCommand GetInstance() {
        return this;
    }

    private void AbortCommand() {
        try {
            ATCommandHelper.nativeSendBytes((int)this.m_iPort, (byte[])ABORT_COMMAND, (int)0, (int)ABORT_COMMAND.length);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class InputStreamDataConnection
    extends InputStream {
        private byte[] m_b = new byte[1];

        private InputStreamDataConnection() {
        }

        public int read() throws IOException {
            int n = this.read(this.m_b, 0, 1);
            if (n < 0) {
                return n;
            }
            return this.m_b[0] >= 0 ? this.m_b[0] & 0x7F : (this.m_b[0] & 0x7F) + 128;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray, int n, int n2) throws IOException {
            Sync sync = ATCommand.this.m_Sync;
            synchronized (sync) {
                int n3;
                if (ATCommand.this.m_State != 3) {
                    throw new IOException("ATCommand class instance is not in transparent data mode");
                }
                do {
                    if ((n3 = ATCommandHelper.nativeReadBytes((int)ATCommand.this.m_iPort, (byte[])byArray, (int)n, (int)n2)) <= 0) {
                        try {
                            ATCommand.this.m_Sync.swait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (n3 > 0 || ATCommand.this.m_State == 3) continue;
                    return -1;
                } while (n3 <= 0);
                return n3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long skip(long l) throws IOException {
            Sync sync = ATCommand.this.m_Sync;
            synchronized (sync) {
                long l2;
                for (l2 = l; l2 > 0L && this.read() > 0; --l2) {
                }
                return l - l2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int available() throws IOException {
            Sync sync = ATCommand.this.m_Sync;
            synchronized (sync) {
                if (ATCommand.this.m_State != 3) {
                    throw new IOException("ATCommand class instance is not in transparent data mode");
                }
                return ATCommandHelper.nativeAvailableBytes((int)ATCommand.this.m_iPort);
            }
        }
    }

    private class OutputStreamDataConnection
    extends OutputStream {
        private byte[] m_b = new byte[1];

        private OutputStreamDataConnection() {
        }

        public void write(int n) throws IOException {
            this.m_b[0] = (byte)n;
            this.write(this.m_b, 0, 1);
        }

        public void write(byte[] byArray) throws IOException, NullPointerException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException, NullPointerException, IndexOutOfBoundsException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (ATCommand.this.m_State != 3) {
                throw new IOException("ATCommand class instance is not in transparent data mode");
            }
            if (n2 > 0) {
                ATCommandHelper.nativeSendBytes((int)ATCommand.this.m_iPort, (byte[])byArray, (int)n, (int)n2);
            }
        }

        public void flush() throws IOException {
        }
    }

    private class Parser {
        private StringBuffer m_strCurrent = new StringBuffer(256);
        private byte[] m_Data = new byte[256];
        private int m_iFoundIndex = -1;
        private final RE[] m_RspPatterns = new RE[]{new RE("(\r\n)+CONNECT( \\d+((/\\D+)*))*(\r\n)+"), new RE("(\r\n)+(OK|ERROR|ABORTED)(\r\n)+"), new RE("(\r\n)+(BUSY|NO DIALTONE|NO CARRIER|NO ANSWER)(\r\n)+"), new RE("(\r\n)+\\+CM(E|S) ERROR: .+(\r\n)+"), new RE("(\r\n)+> $")};

        private Parser() {
        }

        public String Reset() {
            String string = this.m_strCurrent.toString();
            this.m_strCurrent.setLength(0);
            this.m_iFoundIndex = -1;
            return string;
        }

        public int length() {
            return this.m_strCurrent.length();
        }

        public boolean wasConnect() {
            return this.m_iFoundIndex == 0;
        }

        public void ReadUrc() {
            this.ReadData(true);
        }

        public String ReadResponse() {
            this.ReadData(false);
            return this.MatchCurrentData(this.m_RspPatterns);
        }

        private void ReadData(boolean bl) {
            try {
                int n;
                do {
                    if ((n = bl ? ATCommandHelper.nativeReadUrc((int)ATCommand.this.m_iPort, (byte[])this.m_Data, (int)0, (int)this.m_Data.length) : ATCommandHelper.nativeReadBytes((int)ATCommand.this.m_iPort, (byte[])this.m_Data, (int)0, (int)this.m_Data.length)) <= 0) continue;
                    try {
                        this.m_strCurrent.append(new String(this.m_Data, 0, n, ATCommand.ENCODING));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        this.m_strCurrent.append(new String(this.m_Data, 0, n));
                    }
                } while (n >= this.m_Data.length);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private String MatchCurrentData(RE[] rEArray) {
            this.m_iFoundIndex = -1;
            if (this.m_strCurrent.length() > 0) {
                String string = this.m_strCurrent.toString();
                for (int i = 0; i < rEArray.length; ++i) {
                    if (!rEArray[i].match(string)) continue;
                    this.m_iFoundIndex = i;
                    this.m_strCurrent.setLength(0);
                    ATCommand.this.m_State = 0;
                    return string;
                }
            }
            return null;
        }
    }

    private class ComEventThread
    extends Thread {
        private ComEventThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            this.setPriority(10);
            ComEventThread comEventThread = this;
            synchronized (comEventThread) {
                this.notifyAll();
            }
            while (true) {
                try {
                    while (true) {
                        int n = ATCommandHelper.nativeWaitCom((int)ATCommand.this.m_iPort);
                        Sync sync = ATCommand.this.m_Sync;
                        synchronized (sync) {
                            switch (n) {
                                case 1: {
                                    this.HandleData();
                                    break;
                                }
                                case 2: {
                                    this.V24Changed(ATCommandHelper.nativeReadV24((int)ATCommand.this.m_iPort));
                                    break;
                                }
                                case 3: {
                                    this.OptChanged(ATCommandHelper.nativeReadOpt((int)ATCommand.this.m_iPort));
                                    break;
                                }
                                case 4: {
                                    switch (ATCommand.this.m_State) {
                                        case 5: {
                                            ATCommand.this.m_Sync.snotifyAll();
                                            return;
                                        }
                                    }
                                    break;
                                }
                                case 5: {
                                    this.ReadResponse();
                                    ATCommand.this.m_State = 2;
                                    break;
                                }
                                case 7: {
                                    ATCommand.this.m_State = 2;
                                    ATCommand.this.m_Parser.ReadUrc();
                                    break;
                                }
                                case 6: {
                                    ATCommand.this.m_Listeners.callListeners(4, false, ATCommand.this.m_Parser.Reset());
                                    ATCommand.this.m_State = 0;
                                    break;
                                }
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    System.out.println(iOException);
                    continue;
                }
                break;
            }
        }

        private void HandleData() {
            ATCommand.this.m_strResponse = null;
            switch (ATCommand.this.m_State) {
                case 3: {
                    ATCommand.this.m_Sync.snotifyAll();
                    break;
                }
                case 2: {
                    ATCommand.this.m_Parser.ReadUrc();
                    ATCommand.this.m_Listeners.callListeners(4, false, ATCommand.this.m_Parser.Reset());
                    ATCommand.this.m_State = 0;
                    this.ReadResponse();
                    break;
                }
                case 0: 
                case 1: 
                case 4: {
                    this.ReadResponse();
                }
            }
        }

        private void ReadResponse() {
            ATCommand.this.m_strResponse = ATCommand.this.m_Parser.ReadResponse();
            if (ATCommand.this.m_strResponse != null) {
                ATCommand.this.m_Sync.snotifyAll();
                if (ATCommand.this.m_ResponseListener != null) {
                    new ListenerThread(ATCommand.this.m_ResponseListener, ATCommand.this.m_strResponse).start();
                    ATCommand.this.m_ResponseListener = null;
                }
                if (ATCommand.this.m_Parser.wasConnect()) {
                    ATCommand.this.m_State = 3;
                    ATCommand.this.m_V24State = ATCommand.this.m_V24State | 0x4000;
                    ATCommandHelper.nativeNotifyCom((int)ATCommand.this.m_iPort);
                    ATCommand.this.m_Listeners.callListeners(3, true, null);
                }
            } else if (ATCommand.this.m_Parser.length() > 1024) {
                if (ATCommand.this.m_ResponseListener != null) {
                    new ListenerThread(ATCommand.this.m_ResponseListener, ATCommand.this.m_Parser.Reset()).start();
                } else {
                    ATCommand.this.AbortCommand();
                }
            }
        }

        private void V24Changed(int n) {
            int n2 = ATCommand.this.m_V24State;
            ATCommand.this.m_V24State = ATCommand.this.m_V24State & 0xFFFFFF00 | n & 0xFF;
            if ((n2 & 0x10) != (n & 0x10)) {
                ATCommand.this.m_Listeners.callListeners(1, (n & 0x10) != 0, null);
            }
            if ((n2 & 0x40) != (n & 0x40)) {
                ATCommand.this.m_Listeners.callListeners(2, (n & 0x40) != 0, null);
            }
            if ((n2 & 0x80) != (n & 0x80)) {
                ATCommand.this.m_Listeners.callListeners(0, (n & 0x80) != 0, null);
            }
        }

        private void OptChanged(int n) {
            int n2 = ATCommand.this.m_V24State;
            ATCommand.this.m_V24State = ATCommand.this.m_V24State & 0xFFFF00FF | n & 0xFF00;
            if ((n2 & 0x4000) != (n & 0x4000)) {
                if ((n & 0x4000) != 0) {
                    ATCommand.this.m_V24State = ATCommand.this.m_V24State & 0xFFFFBFFF;
                } else {
                    if (ATCommand.this.m_State != 4) {
                        ATCommand.this.m_State = 0;
                        ATCommand.this.m_Parser.Reset();
                        ATCommand.this.m_Sync.snotifyAll();
                    }
                    ATCommand.this.m_Listeners.callListeners(3, false, null);
                }
            }
        }
    }

    private class Listeners {
        private Hashtable m_listenerTable = new Hashtable(10);

        private Listeners() {
        }

        public synchronized void addListener(ATCommandListener aTCommandListener) {
            this.m_listenerTable.put(aTCommandListener, aTCommandListener);
        }

        public synchronized void removeListener(ATCommandListener aTCommandListener) {
            this.m_listenerTable.remove(aTCommandListener);
        }

        public synchronized void clear() {
            this.m_listenerTable.clear();
        }

        public synchronized void callListeners(int n, boolean bl, String string) {
            Enumeration enumeration = this.m_listenerTable.elements();
            while (enumeration.hasMoreElements()) {
                new ListenerThread((ATCommandListener)enumeration.nextElement(), n, bl, string).start();
            }
        }
    }

    private class ListenerThread
    extends OrderedThread {
        private ATCommandListener m_EventListener;
        private ATCommandResponseListener m_ResponseListener;
        private int m_iEventType;
        private boolean m_fState;
        private String m_strUrcRsp;
        public static final int RING = 0;
        public static final int DSR = 1;
        public static final int DCD = 2;
        public static final int CONN = 3;
        public static final int URC = 4;

        public ListenerThread(ATCommandResponseListener aTCommandResponseListener, String string) {
            this.m_EventListener = null;
            this.m_ResponseListener = null;
            this.m_ResponseListener = aTCommandResponseListener;
            this.m_strUrcRsp = string;
        }

        public ListenerThread(ATCommandListener aTCommandListener, int n, boolean bl, String string) {
            this.m_EventListener = null;
            this.m_ResponseListener = null;
            this.m_EventListener = aTCommandListener;
            this.m_iEventType = n;
            this.m_fState = bl;
            this.m_strUrcRsp = string;
        }

        public void OrderedRun() {
            if (this.m_ResponseListener != null) {
                this.m_ResponseListener.ATResponse(this.m_strUrcRsp);
            } else if (this.m_EventListener != null) {
                switch (this.m_iEventType) {
                    case 0: {
                        this.m_EventListener.RINGChanged(this.m_fState);
                        break;
                    }
                    case 2: {
                        this.m_EventListener.DCDChanged(this.m_fState);
                        break;
                    }
                    case 1: {
                        this.m_EventListener.DSRChanged(this.m_fState);
                        break;
                    }
                    case 3: {
                        this.m_EventListener.CONNChanged(this.m_fState);
                        break;
                    }
                    case 4: {
                        if (this.m_strUrcRsp == null || this.m_strUrcRsp.length() <= 0) break;
                        this.m_EventListener.ATEvent(this.m_strUrcRsp);
                    }
                }
            }
        }
    }

    private abstract class OrderedThread
    extends Thread {
        private int m_iExecuteSlot;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OrderedThread() {
            Object object = ATCommand.this.m_oSyncListeners;
            synchronized (object) {
                this.m_iExecuteSlot = ATCommand.this.m_iRegisteredListeners++;
            }
        }

        public abstract void OrderedRun();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = ATCommand.this.m_oSyncListeners;
            synchronized (object) {
                try {
                    while (ATCommand.this.m_iExecutedListeners != this.m_iExecuteSlot) {
                        ATCommand.this.m_oSyncListeners.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.OrderedRun();
            object = ATCommand.this.m_oSyncListeners;
            synchronized (object) {
                ATCommand.this.m_iExecutedListeners++;
                ATCommand.this.m_oSyncListeners.notifyAll();
            }
        }
    }

    private class V24State {
        public static final int CTS = 1;
        public static final int DSR = 16;
        public static final int DCD = 64;
        public static final int RI = 128;
        public static final int V24MASK = 255;
        public static final int BREAK = 512;
        public static final int CSD = 16384;
        public static final int OPTMASK = 65280;

        private V24State() {
        }
    }

    private class ATState {
        public static final int IDLE = 0;
        public static final int RESPONSE = 1;
        public static final int URC = 2;
        public static final int DATA = 3;
        public static final int BREAK = 4;
        public static final int CLOSING = 5;

        private ATState() {
        }
    }

    private class Sync {
        private Sync() {
        }

        public synchronized void swait() throws InterruptedException {
            this.wait();
        }

        public synchronized void snotifyAll() {
            this.notifyAll();
        }
    }
}

