/*
 * Decompiled with CFR 0.152.
 */
package tu41mc;

import com.cinterion.io.ATCommand;
import com.cinterion.io.ATCommandFailedException;
import com.cinterion.io.I2cBusConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.CommConnection;
import javax.microedition.io.Connector;
import javax.microedition.midlet.MIDlet;
import tu41mc.LedThread;

public class IMlet
extends MIDlet {
    I2cBusConnection cc;
    InputStream inI2C;
    OutputStream outI2C;
    CommConnection com;
    InputStream isCom;
    OutputStream osCom;
    private static final String writeAddress = "A2";
    private static final String readAddress = "A3";
    private static final String keepalive = "at$java\r";
    private static final byte[] keepaliveBytes = "at$java\r".getBytes();
    private static final String led3gStart = "at$gsm3g=";
    private static final String simStart = "at$simok=";
    private static String i2CEnd = "00";
    private static byte atEnd = (byte)13;
    private static boolean debug = false;
    private static byte[] bytes = new byte[520];
    private static char[] chars = new char[260];
    private static int nextI2CId = 97;
    private static long lastKeepalive = 0L;
    private static long keepalivePeriod = 40000L;
    private static boolean now3g = false;
    private static int nowCsq = 0;
    private static boolean changed3g = false;
    private static boolean simChanged = false;
    private static boolean simInserted = false;
    private static int simRegistered = 0;
    private static final byte[] rs232to422 = "at$rs232tors422\r".getBytes();
    private static final byte[] rs422to232 = "at$rs422tors232\r".getBytes();
    private static final byte[] rs232to422ok = "$rs232tors422\rOK\r\n".getBytes();
    private static final byte[] rs422to232ok = "$rs422tors232\rOK\r\n".getBytes();
    private static final byte[] rs232to422err = "$rs232tors422\rERROR\r\n".getBytes();
    private static final byte[] rs422to232err = "$rs422tors232\rERROR\r\n".getBytes();
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startApp() {
        ATCommand atCommand;
        block48: {
            IMlet.log("app started");
            while (true) {
                try {
                    atCommand = new ATCommand(false);
                }
                catch (ATCommandFailedException e) {
                    IMlet.log("NOT got ATCommand");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {}
                    continue;
                }
                break;
            }
            IMlet.log("got ATCommand");
            try {
                String scfg = atCommand.send("AT^SCFG?\r");
                IMlet.log(scfg);
                if (scfg.indexOf("\"Gpio/mode/SYNC\",\"std\"") >= 0) break block48;
                scfg = atCommand.send("AT^SCFG=\"GPIO/mode/SYNC\",\"std\"\r");
                IMlet.log(scfg);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                scfg = atCommand.send("AT&W\r");
                IMlet.log(scfg);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                scfg = atCommand.send("AT+CFUN=1,1\r");
                IMlet.log(scfg);
                this.destroyApp(true);
                return;
            }
            catch (ATCommandFailedException e) {
                // empty catch block
            }
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            atCommand.send("AT^SLED=2,50\r");
        }
        catch (ATCommandFailedException e) {
            // empty catch block
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            atCommand.send("AT^SCFG=\"Gpio/mode/ASC1\",\"std\"\r");
        }
        catch (ATCommandFailedException e) {
            // empty catch block
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            atCommand.send("AT^SCFG=\"Serial/Interface/Allocation\",\"1\"\r");
        }
        catch (ATCommandFailedException e) {
            // empty catch block
        }
        new LedThread(atCommand).start();
        while (true) {
            try {
                this.openI2CTillSuccess();
                IMlet.log("i2c opened");
                this.openComTillSuccess();
                IMlet.log("com opened");
                while (true) {
                    int pos;
                    if ((pos = this.readComBlocking()) <= 0) {
                        continue;
                    }
                    boolean isRs232 = this.arraysEqual(bytes, pos, rs232to422);
                    boolean isRs422 = this.arraysEqual(bytes, pos, rs422to232);
                    if (isRs232 || isRs422) {
                        CommConnection rs232 = null;
                        CommConnection rs422 = null;
                        OutputStream os = null;
                        InputStream is = null;
                        try {
                            rs232 = this.openRs(true);
                            rs422 = this.openRs(false);
                            byte[] toWrite = isRs232 ? rs232to422 : rs422to232;
                            IMlet.log(isRs232 ? "will write 232 to 422" : "will write 422 to 232");
                            if (isRs232) {
                                os = rs232.openOutputStream();
                                is = rs422.openInputStream();
                                IMlet.log("os for 232, is for 422");
                            } else {
                                os = rs422.openOutputStream();
                                is = rs232.openInputStream();
                                IMlet.log("os for 422, is for 232");
                            }
                            os.write(toWrite);
                            IMlet.log("wrote: " + new String(toWrite));
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {
                                // empty catch block
                            }
                            byte[] read = new byte[is.available()];
                            is.read(read);
                            IMlet.log("read " + read.length + " bytes: " + new String(read));
                            if (this.arraysEqual(toWrite, toWrite.length, read)) {
                                this.osCom.write(isRs232 ? rs232to422ok : rs422to232ok);
                            } else {
                                this.osCom.write(isRs232 ? rs232to422err : rs422to232err);
                            }
                            this.silentClose(os);
                            this.silentClose(is);
                            this.silentClose(rs232);
                            this.silentClose(rs422);
                        }
                        catch (IOException ex) {
                            IMlet.log(ex);
                            this.osCom.write(isRs232 ? rs232to422err : rs422to232err);
                        }
                        finally {
                            this.silentClose(os);
                            this.silentClose(is);
                            this.silentClose(rs232);
                            this.silentClose(rs422);
                        }
                        continue;
                    }
                    String command = "<".concat("" + (char)nextI2CId).concat(writeAddress).concat(IMlet.bytesToHex(bytes, 0, pos)).concat(">");
                    IMlet.log(command);
                    this.outI2C.write(command.getBytes());
                    this.outI2C.flush();
                    lastKeepalive = System.currentTimeMillis();
                    pos = this.readI2CAnswer();
                    if (pos == 0) {
                        throw new IOException("null answer");
                    }
                    String ans = new String(bytes, 0, pos);
                    IMlet.log(ans);
                    if (!ans.equalsIgnoreCase("{" + (char)nextI2CId + "+}")) {
                        throw new IOException("not acknowledge");
                    }
                    this.incrNextI2CId();
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    byte[] read = ("<" + (char)nextI2CId + readAddress + "00FA>").getBytes();
                    IMlet.log(new String(read));
                    this.outI2C.write(read);
                    this.outI2C.flush();
                    lastKeepalive = System.currentTimeMillis();
                    pos = this.readI2CAnswer();
                    if (pos == 0) {
                        throw new IOException("null answer");
                    }
                    String s = new String(bytes, 0, pos);
                    IMlet.log("raw answer: " + s + ", hex from: " + s.substring(3, s.length() - 1));
                    pos = IMlet.hexToBytes(s.substring(3, s.length() - 1));
                    this.incrNextI2CId();
                    if (pos == 0) {
                        throw new IOException("invalid hex message");
                    }
                    ans = new String(bytes, 0, pos);
                    IMlet.log(ans);
                    this.osCom.write(bytes, 0, pos);
                    this.osCom.flush();
                    IMlet.log("wrote to com " + pos + " bytes");
                }
            }
            catch (IOException ex) {
                IMlet.log(ex);
                this.closeI2C();
                this.silentCloseCom();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    private boolean arraysEqual(byte[] one, int length, byte[] two) {
        if (one.length < length || two.length != length) {
            IMlet.log("one length: " + one.length + ", length: " + length + ", two length: " + two.length);
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (one[i] == two[i]) continue;
            IMlet.log("not equal symbol number " + i + ", one " + one[i] + ", two " + two[i] + ", one: " + new String(one) + ", two: " + new String(two));
            return false;
        }
        return true;
    }

    private void sendKeepalive() throws IOException {
        IMlet.log(keepalive);
        String command = "<".concat("" + (char)nextI2CId).concat(writeAddress).concat(IMlet.bytesToHex(keepaliveBytes, 0, keepaliveBytes.length)).concat(">");
        IMlet.log(command);
        this.outI2C.write(command.getBytes());
        this.outI2C.flush();
        int pos = this.readI2CAnswer();
        if (pos == 0) {
            throw new IOException("null answer");
        }
        String ans = new String(bytes, 0, pos);
        IMlet.log(ans);
        if (!ans.equalsIgnoreCase("{" + (char)nextI2CId + "+}")) {
            throw new IOException("not acknowledge");
        }
        lastKeepalive = System.currentTimeMillis();
        this.incrNextI2CId();
    }

    public static void changedSignal(boolean available, int csq) {
        changed3g = true;
        now3g = available;
        nowCsq = csq;
    }

    public static void simInfoChanged(boolean ins, int reg) {
        simChanged = true;
        simInserted = ins;
        simRegistered = reg;
    }

    private void incrNextI2CId() {
        if (++nextI2CId > 122) {
            nextI2CId = 97;
        }
    }

    private void send3gAvailable(boolean available, int csq) throws IOException {
        String atCom = led3gStart + (available ? "1" : "0") + "," + csq + (char)atEnd;
        this.processWaitAck(atCom);
    }

    private void sendSimChanged(boolean ins, int reg) throws IOException {
        String atCom = simStart + (ins ? 1 : 0) + "," + reg + (char)atEnd;
        this.processWaitAck(atCom);
    }

    private void processWaitAck(String atCom) throws IOException {
        byte[] b = atCom.getBytes();
        IMlet.log(atCom);
        String command = "<".concat("" + (char)nextI2CId).concat(writeAddress).concat(IMlet.bytesToHex(b, 0, b.length)).concat(">");
        IMlet.log(command);
        this.outI2C.write(command.getBytes());
        this.outI2C.flush();
        int pos = this.readI2CAnswer();
        if (pos == 0) {
            throw new IOException("null answer");
        }
        String ans = new String(bytes, 0, pos);
        IMlet.log(ans);
        if (!ans.equalsIgnoreCase("{" + (char)nextI2CId + "+}")) {
            throw new IOException("not acknowledge");
        }
        lastKeepalive = System.currentTimeMillis();
        this.incrNextI2CId();
    }

    private void sendPeriodicCommands() throws IOException {
        if (changed3g) {
            changed3g = false;
            this.send3gAvailable(now3g, nowCsq);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        if (simChanged) {
            simChanged = false;
            this.sendSimChanged(simInserted, simRegistered);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        if (System.currentTimeMillis() - lastKeepalive > keepalivePeriod) {
            this.sendKeepalive();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private int readComBlocking() throws IOException {
        this.isCom.skip(this.isCom.available());
        int pos = 0;
        do {
            if (pos >= bytes.length) {
                pos = 0;
            }
            while (this.isCom.available() < 1) {
                this.sendPeriodicCommands();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.isCom.read(bytes, pos++, 1);
        } while (bytes[pos - 1] != atEnd);
        return pos;
    }

    private CommConnection openRs(boolean rs232) throws IOException {
        CommConnection rs = (CommConnection)Connector.open((String)("comm:COM" + (rs232 ? "0" : "1") + ";bitsperchar=8;stopbits=1;parity=none;baudrate=115200"));
        return rs;
    }

    private void openComTillSuccess() throws IOException {
        while (true) {
            try {
                this.com = (CommConnection)Connector.open((String)"comm:USB4;blocking=off;autocts=off;bitsperchar=8;stopbits=1;parity=none;baudrate=115200");
                this.isCom = this.com.openInputStream();
                this.osCom = this.com.openOutputStream();
            }
            catch (IOException e) {
                IMlet.log(e);
                this.silentCloseCom();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.sendPeriodicCommands();
                continue;
            }
            break;
        }
    }

    private void openI2CTillSuccess() {
        while (true) {
            try {
                this.cc = (I2cBusConnection)Connector.open((String)"i2c:0;baudrate=100");
                this.inI2C = this.cc.openInputStream();
                this.outI2C = this.cc.openOutputStream();
            }
            catch (IOException ex) {
                IMlet.log(ex);
                this.closeI2C();
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
    }

    private int readI2CAnswer() throws IOException {
        int pos = 0;
        for (int i = 0; i < 4; ++i) {
            if (this.inI2C.available() > 0) {
                this.inI2C.read(bytes, pos++, 1);
                --i;
                if (bytes[pos - 1] != 125) continue;
                break;
            }
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return pos;
    }

    public static void log(String s) {
        if (debug) {
            System.out.println(s);
        }
    }

    public static void log(Exception e) {
        if (debug) {
            e.printStackTrace();
        }
    }

    private void closeI2C() {
        if (this.inI2C != null) {
            try {
                this.inI2C.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (this.outI2C != null) {
            try {
                this.outI2C.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (this.cc != null) {
            try {
                this.cc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
        this.closeI2C();
        this.silentCloseCom();
        this.notifyDestroyed();
    }

    public static String bytesToHex(byte[] bytes, int start, int length) {
        int j;
        for (j = start; j < length; ++j) {
            int v = bytes[j] & 0xFF;
            IMlet.chars[(j - start) * 2] = hexArray[v >>> 4];
            IMlet.chars[(j - start) * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(chars, 0, (j - start) * 2);
    }

    public static int hexToBytes(String hex) {
        int i;
        int len;
        int pos = hex.indexOf(i2CEnd);
        while (pos % 2 == 1 && pos != -1) {
            pos = hex.indexOf(i2CEnd, pos + 1);
        }
        if (pos > -1) {
            hex = hex.substring(0, pos);
        }
        if ((len = hex.length()) % 2 != 0) {
            return 0;
        }
        for (i = 0; i < len; i += 2) {
            int h = IMlet.hexToBin(hex.charAt(i));
            int l = IMlet.hexToBin(hex.charAt(i + 1));
            if (h == -1 || l == -1) {
                return 0;
            }
            IMlet.bytes[i / 2] = (byte)(h * 16 + l);
        }
        return i / 2;
    }

    private static int hexToBin(char ch) {
        if ('0' <= ch && ch <= '9') {
            return ch - 48;
        }
        if ('A' <= ch && ch <= 'F') {
            return ch - 65 + 10;
        }
        if ('a' <= ch && ch <= 'f') {
            return ch - 97 + 10;
        }
        return -1;
    }

    private void silentCloseCom() {
        this.silentClose(this.osCom);
        this.silentClose(this.isCom);
        this.silentClose(this.com);
    }

    private void silentClose(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void silentClose(OutputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void silentClose(CommConnection is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

